<h4 class="ulz--title">{{ $title }}</h4>

<form>
    <div class="ulz-grid">

        {{ $form->render([
            'type' => 'number',
            'id' => 'ulz_price',
            'name' => $strings->price_base,
            'min' => 0,
            'step' => 0.01,
            'required' => boolval( ! $action_fields->allow_not_required_price ),
        ]) }}

        @if( $action_fields->allow_extra_pricing )

            <div class="ulz-form-group ulz-col-12">
                <h5 class="ulz-mb-0">{{ $strings->extra_service_pricing }}</h5>
            </div>

            {{ $form->render([
                'type' => 'repeater',
                'id' => 'ulz_extra_pricing',
                'name' => $strings->add_extra_pricing,
                'button' => [
                    'label' => $strings->add_service
                ],
                'templates' => [

                    /*
                     * service
                     *
                     */
                    'service' => [
                        'name' => $strings->service,
                        'heading' => 'name',
                        'fields' => [

                            'name' => [
                                'type' => 'text',
                                'name' => $strings->service_name,
                                'placeholder' => $strings->service_name_placeholder,
                                'col' => 4,
                            ],
                            'type' => [
                                'type' => 'select',
                                'name' => $strings->service_type,
                                'options' => [
                                    'single_fee' => $strings->single_fee,
                                ],
                                'allow_empty' => false,
                                'col' => 4,
                            ],
                            'price' => [
                                'type' => 'number',
                                'name' => $strings->service_price,
                                'min' => 0,
                                'step' => 0.01,
                                'col' => 4,
                            ],

                        ]
                    ],

                ]
            ]) }}

        @endif

        @if( $action_fields->allow_addons )

            <div class="ulz-form-group ulz-col-12">
                <h5 class="ulz-mb-0">{{ $strings->addons }}</h5>
            </div>

            {{ $form->render([
                'type' => 'repeater',
                'id' => 'ulz_addons',
                'name' => $strings->add_addons,
                'button' => [
                    'label' => $strings->add_addon
                ],
                'templates' => [

                    /*
                     * addon
                     *
                     */
                    'addon' => [
                        'name' => $strings->addon,
                        'heading' => 'name',
                        'fields' => [
                            'name' => [
                                'type' => 'text',
                                'name' => $strings->addon_name,
                                'placeholder' => $strings->enter_addon_name,
                                'col' => 6,
                            ],
                            'price' => [
                                'type' => 'number',
                                'name' => $strings->addon_price,
                                'min' => 0,
                                'step' => 0.01,
                                'col' => 6,
                            ],
                            'key' => [
                                'type' => 'auto-key',
                                'name' => $strings->addon_id,
                            ],
                        ]
                    ],

                ]
            ]) }}

        @endif

    </div>
</form>
